package com.example.possdkforandroid;

import java.io.UnsupportedEncodingException;

import android.os.Bundle;
import android.app.Activity;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;

public class PDF417CodeActivity extends Activity {
	
	//Parameter variable
	private String pdf417_data = null;
	private int DataLength = 0;
	private int AppearanceToHeight = 0;
	private int AppearanceToWidth = 0;
	private int RowsNumber = 0;
	private int ColumnsNumber = 0;
	private int Xsize = 0;
	private int LineHeight = 0;
	private int nCorrectGrade = 0;
	
	//Operate control
	private Button btnOK, btnRet;
	private EditText txtdata, txtappearwidth,txtRowsNum,txtColNum,txtLineHeight;
	private Spinner pdf417_appearheight_spi,pdf417_xSize_spi,pdf417_corgrade_spi;
	
	//TestPrint variable
	private TestPrintInfo testprint;
	private int error_code = 0;
	
	//Returned Value Statement
	public static final int POS_SUCCESS=1000;		//success
	public static final int ERR_PROCESSING = 1001;	//fail

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.pdf417code);
        
        //************************************************************************************************
        //AppearanceToHeight Spinner
        pdf417_appearheight_spi = (Spinner)findViewById(R.id.pdf417_appearheight_spi);
        String[] appearheight_items = {"1","2","3","4","5","6","7","8","9","10"};
    	ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, appearheight_items);
    	adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
    	pdf417_appearheight_spi.setAdapter(adapter);
    	pdf417_appearheight_spi.setSelection(1);
    	
    	//*************************************************************************************************
    	//xSize Spinner
    	pdf417_xSize_spi = (Spinner)findViewById(R.id.pdf417_xSize_spi);
        String[] xSize_items = {"1","2","3","4","5","6","7"};
    	adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, xSize_items);
    	adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
    	pdf417_xSize_spi.setAdapter(adapter);
    	pdf417_xSize_spi.setSelection(2);
    	
    	//*************************************************************************************************
    	//CorrectGrade Spinner
    	pdf417_corgrade_spi = (Spinner)findViewById(R.id.pdf417_corgrade_spi);
        String[] corgrade_items = {"1","2","3","4","5","6","7"};
    	adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, corgrade_items);
    	adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
    	pdf417_corgrade_spi.setAdapter(adapter);
    	pdf417_corgrade_spi.setSelection(2);
    	
    	//Get PrintData EditText Object
    	txtdata = (EditText)findViewById(R.id.pdf417_data);
    	
    	//Get AppearanceToWidth EditText Object
    	txtappearwidth = (EditText)findViewById(R.id.pdf417_appearwidth);
    	
    	//Get RowsNumber EditText Object
    	txtRowsNum = (EditText)findViewById(R.id.pdf417_rownum);
    	
    	//Get ColumnsNumber EditText Object
    	txtColNum = (EditText)findViewById(R.id.pdf417_colnum);
    	
    	//Get LineHeight EditText Object
    	txtLineHeight = (EditText)findViewById(R.id.pdf417_height);
        
		//****************************************************************************************************
		//Get parameter and print
		btnOK = (Button)findViewById(R.id.pdf417_print_but);
		btnOK.setOnClickListener(new OnClickListener(){
			@Override
			public void onClick(View v) {
				String spi_str;
				testprint = new TestPrintInfo();
				
				//Get PrintData
				pdf417_data = txtdata.getText().toString();
				
				//Get AppearanceToHeight
				spi_str = pdf417_appearheight_spi.getSelectedItem().toString();
				AppearanceToHeight = Integer.parseInt(spi_str);
				
				//Get AppearanceToWidth
				spi_str = txtappearwidth.getText().toString();
				if(spi_str.length() == 0){
					Toast.makeText(PDF417CodeActivity.this, "Edit box value cannot be empty.",Toast.LENGTH_LONG).show();	
					return;
				}
				AppearanceToWidth = Integer.parseInt(spi_str);
				
				//Get RowsNumber
				spi_str = txtRowsNum.getText().toString();
				if(spi_str.length() == 0){
					Toast.makeText(PDF417CodeActivity.this, "Edit box value cannot be empty.",Toast.LENGTH_LONG).show();	
					return;
				}
				RowsNumber = Integer.parseInt(spi_str);
				
				//Get ColumnsNumber 
				spi_str = txtColNum.getText().toString();
				if(spi_str.length() == 0){
					Toast.makeText(PDF417CodeActivity.this, "Edit box value cannot be empty.",Toast.LENGTH_LONG).show();	
					return;
				}
				ColumnsNumber = Integer.parseInt(spi_str);
				
				//Get xSize
				spi_str = pdf417_xSize_spi.getSelectedItem().toString();
				Xsize = Integer.parseInt(spi_str);
				
				//Get LineHeight
				spi_str = txtLineHeight.getText().toString();
				if(spi_str.length() == 0){
					Toast.makeText(PDF417CodeActivity.this, "Edit box value cannot be empty.",Toast.LENGTH_LONG).show();	
					return;
				}
				LineHeight = Integer.parseInt(spi_str);
				
				//Get CorrectGrade
				spi_str = pdf417_corgrade_spi.getSelectedItem().toString();
				nCorrectGrade = Integer.parseInt(spi_str);
				
				//Get data length
				try {
					DataLength = pdf417_data.getBytes("GB18030").length;
				} catch (UnsupportedEncodingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
				//USB
				if(MainActivity.port_type == MainActivity.USBPORT)
				{
					error_code = testprint.TestPrintPDF417(USBActivity.pos_usb, USBActivity.printMode, pdf417_data, DataLength, 
							AppearanceToHeight, AppearanceToWidth, RowsNumber, ColumnsNumber, Xsize, LineHeight, nCorrectGrade);
					if(error_code != POS_SUCCESS)
					{
						Toast.makeText(PDF417CodeActivity.this, "Failed to print PDF417.",Toast.LENGTH_LONG).show();
					}
				}
				//COM
				else if(MainActivity.port_type == MainActivity.SERIALPORT)
				{
					error_code = testprint.TestPrintPDF417(SerialActivity.pos_com, SerialActivity.printMode, pdf417_data, DataLength, 
							AppearanceToHeight, AppearanceToWidth, RowsNumber, ColumnsNumber, Xsize, LineHeight, nCorrectGrade);
					if(error_code != POS_SUCCESS)
					{
						Toast.makeText(PDF417CodeActivity.this, "Failed to print PDF417.",Toast.LENGTH_LONG).show();
					}
				}
				//WIFI
				else if(MainActivity.port_type == MainActivity.WIFIPORT)
				{
					error_code = testprint.TestPrintPDF417(WIFIActivity.pos_wifi, WIFIActivity.printMode, pdf417_data, DataLength, 
							AppearanceToHeight, AppearanceToWidth, RowsNumber, ColumnsNumber, Xsize, LineHeight, nCorrectGrade);
					if(error_code != POS_SUCCESS)
					{
						Toast.makeText(PDF417CodeActivity.this, "Failed to print PDF417.",Toast.LENGTH_LONG).show();
					}
				}
				//Bluetooth
				else if(MainActivity.port_type == MainActivity.BLUETOOTHPORT)
				{
					error_code = testprint.TestPrintPDF417(BlueActivity.pos_blue, BlueActivity.printMode, pdf417_data, DataLength, 
							AppearanceToHeight, AppearanceToWidth, RowsNumber, ColumnsNumber, Xsize, LineHeight, nCorrectGrade);
					if(error_code != POS_SUCCESS)
					{
						Toast.makeText(PDF417CodeActivity.this, "Failed to print PDF417.",Toast.LENGTH_LONG).show();
					}
				}
			   
			}});
		//*************************************************************************************************
		//Back
		btnRet = (Button)findViewById(R.id.pdf417_ret_but);
		btnRet.setOnClickListener(new OnClickListener(){
			@Override
			public void onClick(View v) {
				back();
			}
		});
    }
	private void back() {
		finish();
	}

}
